package gov.va.med.domain.service.messaging.encode.hl7.structure;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.segment.ORC;
import ca.uhn.hl7v2.model.v24.segment.RXE;
import ca.uhn.log.HapiLogFactory;

/**
 * OMP_O09_ORCRXE
 *
 * @author Slava Uchitel
 * @version $Id: OMP_O09_ORCRXE.java,v 1.1.1.1 2005/05/13 19:40:43 jon.crater Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public class OMP_O09_ORCRXE extends AbstractGroup
{ 
    /** 
	 * Creates a new OMP_O09_ORCRXE Group.
	 */
	public OMP_O09_ORCRXE(Group parent) {
	   super(parent);
	   try {
	      this.add(ORC.class, true, false);
	      this.add(RXE.class, true, false);
	   } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OMP_O09_PIDPD1NTEPV1PV2IN1IN2IN3GT1AL1 - this is probably a bug in the source code generator.", e);
	   }
	}
    
    /**
	 * Returns ORC - creates it if necessary
	 */
	public ORC getORC() { 
	   ORC ret = null;
	   try {
	      ret = (ORC)this.get("ORC");
	   } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	   }
	   return ret;
	}
    
    /**
	 * Returns ORC - creates it if necessary
	 */
	public RXE getRXE() { 
	   RXE ret = null;
	   try {
	      ret = (RXE)this.get("RXE");
	   } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	   }
	   return ret;
	}

} 
